class Proj_Tower_RingOfFire extends Projectile;

var() texture SpriteAnim[6];
var int i;

event ZoneChange( ZoneInfo NewZone )
{
	if ( NewZone.IsA('NoPlayerZone') )
		Self.Destroy();
}

simulated function Timer()
{
	if ( Level.Netmode != NM_DedicatedServer )
		Texture = SpriteAnim[i];
	i++;
	if (i>=6) i=0;
}

simulated function PostBeginPlay()
{

	Texture = SpriteAnim[0];
	i=1;
	SetTimer(0.15,True);

	PlaySound(SpawnSound);
	Velocity = Vector(Rotation) * speed;
	MakeNoise ( 1.0 );

	//Super.PostBeginPlay();
}

auto state Flying
{

simulated function ProcessTouch (Actor Other, Vector HitLocation)
{
	if ( !Other.IsA('Tower') && !Other.IsA('PlayerPawn') )
		{
		if ( Role == ROLE_Authority )
			{
			if ( PBPRI(instigator.PlayerReplicationInfo).RingOfFireLevel > 1 )
				Other.TakeDamage(1.5 * Damage, instigator,HitLocation, 10.0 * Normal(velocity), 'Tower');
			else
				Other.TakeDamage(Damage, instigator,HitLocation, 10.0 * Normal(velocity), 'Tower');
			}
		//Explode(HitLocation, Vect(0,0,0));
		}
}

simulated function Explode(vector HitLocation, vector HitNormal)
{
Local FX_FlameExplosion s;

	s = Spawn(class'FX_FlameExplosion',,,HitLocation+HitNormal*9);
	s.RemoteRole = ROLE_None;
	Destroy();
}

Begin:
	Sleep(3);
	Explode(Location, Vect(0,0,0));
}

defaultproperties
{
     SpriteAnim(0)=Texture'UnrealI.Effects.gbProj0'
     SpriteAnim(1)=Texture'UnrealI.Effects.gbProj1'
     SpriteAnim(2)=Texture'UnrealI.Effects.gbProj2'
     SpriteAnim(3)=Texture'UnrealI.Effects.gbProj3'
     SpriteAnim(4)=Texture'UnrealI.Effects.gbProj4'
     SpriteAnim(5)=Texture'UnrealI.Effects.gbProj5'
     speed=500.000000
     Damage=3.000000
     ImpactSound=Sound'UnrealShare.flak.expl2'
     RemoteRole=ROLE_SimulatedProxy
     LifeSpan=0.450000
     DrawType=DT_Sprite
     Style=STY_Translucent
     Texture=Texture'UnrealI.Effects.gbProj0'
     DrawScale=0.750000
     Fatness=0
     bUnlit=True
     LightType=LT_Steady
     LightEffect=LE_NonIncidence
     LightBrightness=255
     LightHue=5
     LightSaturation=16
     LightRadius=9
}
